

// This file calls and runs the model. 

// ===================================================================================================================
// Call the initialization file
        @#include "Model_initialization.mod"
// ===================================================================================================================

// ===================================================================================================================

// Report all parameters below, including the estimated ones
        
betaP = 0.99;         // patient HH discount factor
betaI = 0.96;         // impatient HH discount factor
betaE = 0.96;         // entrepreneur discount factor
epsilonP=0.081;         // Housing preference parameter; patient HHs
epsilonI=0.081;         // Housing preference parameter; impatient HHs
nuP = 0.27;            // leisure preference parameter; patient HHs
nuI = 0.27;            // leisure preference parameter; impatient HHs
sigmacP = 1;          // CRRA, consumption, pat. HHs
sigmahP = 1;          // CRRA, housing, pat. HHs       
sigmanP = 9;          // CCRA, leisure, pat. HHs
sigmacI = 1;          // CRRA, consumption, impat. HHs
sigmahI = 1;          // CRRA, housing, impat. HHs         
sigmanI = 9;          // CCRA, leisure, pat. HHs          
sigmacE = 1;          // CRRA, consumption, entrepeneurs
// Technology and related parameters
nI = 1/3 ;            // Fraction of impatient HHs in the economy
nE = 1/3 ;            // Fraction of entrepreneurs in the economy
alpha = 0.7;          // patient HHs' share of total labor          
gamma=0.6355;            // Total labor's share of input factors
phi=0.1340;        // Land's share of input factors 
delta=0.0518;       // capital depreciation rate
n = ( (((1-nI-nE)^alpha)*nI^(1-alpha) )^gamma)*nE^(1-gamma);
sbarI=0.6735;
sbarE=sbarI+0.09;
varthetaI=0.0093;
varthetaE=0.6975;
xiI=0.0144;                      
xiE=0.125;           
        

// Load parameter vector
load paramvec;

sigma_ea=paramvec(1); 
rhoa=paramvec(2); 
sigma_eps=paramvec(3); 
rho_eps=paramvec(4); 
sigma_es=paramvec(5); 
rhos=paramvec(6); 
omega=paramvec(7); 
rhoP=paramvec(8); 
rhoI=paramvec(9);
rhoE=rhoI;


// ===================================================================================================================

// ===================================================================================================================
// Call the steady state
        @#include "Model_steady.mod"
        save('muIss','muIss'); save('muEss','muEss');
// ===================================================================================================================

// ===================================================================================================================
// Call the model
        @#include "Skewness_Model.mod"

// ===================================================================================================================

// ===================================================================================================================
// Call the shocks

shocks;

// Here you need to choose which type of shock to do irfs for!
var epsilon_eahat; stderr 1;
//var epsilon_eshat; stderr 1;
//var epsilon_epshat; stderr 1;

	@#for index in 0:( TshadowI - 1 )
		var epsilon_shadowImp_@{index} = 1;
        var epsilon_shadowEnt_@{index} = 1;
	@#endfor
	@#define index = 10000000000

end;

stoch_simul(order = 1, irf = @{TIRF}, nograph, noprint);

// ===================================================================================================================
// Include code for ONBC solution
CCL_SolveShadows;
Model7Data = StartDynSimM7( @{TshadowI}, @{TIRF}, 'muihat', 'muehat', steadys, var_list_ );